DROP VIEW public.v_cupomfiscal_pbm;
DROP VIEW public.v_nfce;
DROP VIEW public.v_pdv_vd;
DROP VIEW public.v_cupomfiscal;



create or replace function addcolumn() 
returns void as 
$body$ 
begin 
    
    if  not exists (select 1 
					  from information_schema.columns 
                     where table_name= 'pdv_vd' 
                       and column_name='tipo_pbm') then 
		   
		ALTER table pdv_vd alter column tipo_pbm type integer;
        
		raise notice 'operacao realizada com sucesso.';
    else 
		raise notice 'coluna existe.'; 
    end if; 
      
end; 
-- fim bloco principal 
$body$ 
language plpgsql volatile 
  cost 100; 
alter function addcolumn() owner to postgres; 
select addcolumn(); 
drop function addcolumn();







CREATE OR REPLACE VIEW public.v_cupomfiscal_pbm AS
 SELECT vd.cd_emp,
    vd.cd_filial,
    vd.dt_vd,
    vd.dt_cad,
    vd.cd_cx,
    vd.cd_vd,
    vd.nr_ecf,
    vd.st_vd,
    vd.cd_conv,
        CASE
            WHEN vd.tipo_pbm::numeric > 0::numeric THEN
            CASE
                WHEN vd.cd_cli_pbm = 0::numeric THEN ( SELECT rc_cli.cd_cli
                   FROM rc_cli
                  WHERE rc_cli.rot_conv_ext::numeric = vd.tipo_pbm::numeric AND rc_cli.sts_cli = 0::numeric
                 LIMIT 1)
                ELSE vd.cd_cli_pbm
            END
            ELSE vd.cd_cli
        END AS cd_cli_conv,
    NULL::character varying AS cgc_conv,
    vd.tipo_pbm,
        CASE vd.tipo_pbm
            WHEN 1 THEN 'prevsaude'::character varying
            WHEN 2 THEN 'vida-link'::character varying
            WHEN 3 THEN 'e-pharma'::character varying
            WHEN 4 THEN 'transaction center'::character varying
            WHEN 5 THEN 'farmacia popular'::character varying
            WHEN 6 THEN 'funcional card'::character varying
            ELSE 'outros'::character varying
        END AS nm_conv,
    vd.vlr_conv_pbm AS vlr_conv,
    COALESCE(it.nr_autorizacao_pbm, it.nr_orc_vd_link) AS cd_autorizacao,
    it.cd_it,
    it.cd_prod,
    it.vlr_avista_pbm AS vlr_prod_cli,
    COALESCE(
        CASE
            WHEN it.vlr_reembol_pbm = 0::numeric THEN NULL::numeric
            ELSE it.vlr_reembol_pbm
        END,
        CASE
            WHEN it.vlr_reembol = 0::numeric THEN NULL::numeric
            ELSE it.vlr_reembol
        END) AS vlr_prod_reembolso,
    it.vlr_conv_pbm AS vlr_prod_conv,
    COALESCE(it.cd_usu_libera_pos_pbm, 0::numeric) AS cd_usu_libera_pos_pbm,
    COALESCE(it.valor_desconto_pos_pbm, 0::numeric) AS valor_desconto_pos_pbm,
    COALESCE(vd.flag_consolidado, 0) AS flag_consolidado
   FROM pdv_vd vd
     JOIN pdv_vd_it it ON vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd
  WHERE vd.st_vd > '-1'::integer::numeric AND vd.tipo_pbm > 0 AND (length(it.nr_autorizacao_pbm::text) > 1 OR length(it.nr_orc_vd_link::text) > 1);

ALTER TABLE public.v_cupomfiscal_pbm
    OWNER TO postgres;




CREATE OR REPLACE VIEW public.v_nfce AS
 SELECT cp.cd_emp,
    cp.cd_filial,
    cp.cd_cx,
    cp.cd_vd,
    cp.dt_vd,
    cp.nr_ecf,
    cp.cd_cli,
    cp.cgc_cpf,
    cp.nm_cli,
    cp.vlr_desc,
    cp.vlr_dinh,
    cp.vlr_chqs,
    cp.vlr_troco,
    cp.vlr_cartoes_linx,
    it.cd_benef,
    ( SELECT COALESCE(sum(item.vl_cartao), 0::numeric) AS "coalesce"
           FROM pdv_vd_tef item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_transacao <> 2::numeric AND item.tp_adm <> 6) AS vlr_cartao,
    ( SELECT COALESCE(sum(item.vl_parc), 0::numeric) AS "coalesce"
           FROM pdv_vd_cred item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd) AS vlr_crediario,
    cp.vlr_tickets,
    cp.vlr_conv,
    cp.vlr_dup,
    cp.vlr_ncc,
    cp.st_vd,
    cp.vlr_conv_pbm,
    ( SELECT COALESCE(sum(item.vlr_liq_it), 0::numeric) AS "coalesce"
           FROM pdv_vd_it item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_it = 1::numeric) AS vlr_to_liq_it,
    ( SELECT COALESCE(sum(item.vlr_liq_it), 0::numeric) - cp.vlr_desc
           FROM pdv_vd_it item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_it = 1::numeric) AS vlr_to_liq_vd,
    ( SELECT COALESCE(sum(item.vlr_tot_it), 0::numeric) AS "coalesce"
           FROM pdv_vd_it item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_it = 1::numeric) AS vlr_to_bruto_it,
    it.cd_it,
    it.cd_barras AS ean,
    it.cd_prod,
        CASE
            WHEN COALESCE(it.ds_prod_vd, ''::character varying)::text = ''::text THEN p.ds_usual
            ELSE it.ds_prod_vd
        END AS ds_prod,
    p.ncm_prod,
    p.vlr_pmc,
    p.ctr_pmc,
    0 AS ean_trib,
    medidas.ds_un AS cd_un_vd,
    it.qt_it,
    it.vlr_it,
    it.vlr_tot_it,
    it.vlr_desc_it,
    it.vlr_liq_it,
    it.cd_trib_fc,
    it.tx_icms_it,
    it.tx_red_it,
    it.st_it,
    it.tipo_imposto,
    it.cd_vend,
    cp.cd_nf_serie,
    cp.cd_usu,
    cp.vlr_imposto,
    cp.vlr_imposto_uf,
    cp.vlr_imposto_mun,
    it.vlr_desc_tot_rat,
    it.nr_cest,
    COALESCE(p.nr_serv, ''::character varying) AS nr_serv,
    cp.hr_vd,
    cp.tipo_pbm,
    cp.tp_emis,
    pdv_cx.cod_ativacao_mfe,
    pdv_cx.signacmfe,
    COALESCE(it.perc_fcp, 0.0) AS perc_fcp,
    COALESCE(it.perc_fecop_st, 0.0) AS perc_fecop_st,
    COALESCE(it.perc_fecop_ret, 0.0) AS perc_fecop_ret,
    COALESCE(it.perc_icms, 0.0) AS perc_icms,
    COALESCE(it.perc_icms_subst, 0.0) AS perc_icms_subst,
    COALESCE(it.perc_red_base_calc, 0.0) AS perc_red_base_calc,
    COALESCE(it.perc_red_base_calc_efet, 0.0) AS perc_red_base_calc_efet,
    COALESCE(it.perc_icms_efet, 0.0) AS perc_icms_efet,
    COALESCE(it.perc_st, 0.0) AS perc_st,
    COALESCE(it.perc_icms_ret, 0.0) AS perc_icms_ret,
    COALESCE(it.motivo_desonerado_icms, 0::numeric) AS motivo_desonerado_icms,
    COALESCE(it.icms_desonerado, 0::numeric) AS icms_desonerado,
    COALESCE(it.vlr_icms_desonerado_it, 0.0) AS vlr_icms_desonerado_it,
    cp.regime_tributario,
    it.origem_produto,
    it.cfop,
    it.vlr_base_calc,
    it.vlr_base_calc_pis,
    it.vlr_base_calc_cofins,
    it.vlr_icms,
    it.vlr_base_subst,
    it.vlr_isento,
    it.vlr_outras,
    it.vlr_icms_subst,
    it.vlr_fecop,
    it.vlr_fecop_st,
    it.vlr_fecop_ret,
    it.vlr_base_calc_efet,
    it.vlr_icms_efet,
    it.vlr_base_calc_ret,
    it.vlr_icms_ret,
    it.vlr_frete_rat,
    cp.vlr_frete_tot,
    pvo.tp_orc_entg
   FROM pdv_vd cp
     JOIN pdv_vd_it it ON cp.cd_emp = it.cd_emp AND cp.cd_filial = it.cd_filial AND cp.cd_vd = it.cd_vd
     JOIN est_prod p ON it.cd_emp = p.cd_emp AND it.cd_prod = p.cd_prod
     JOIN pdv_cx ON cp.cd_emp = pdv_cx.cd_emp AND cp.cd_filial = pdv_cx.cd_filial AND cp.cd_cx = pdv_cx.cd_cx
     LEFT JOIN est_prod_un_med medidas ON p.cd_emp = medidas.cd_emp AND p.cd_un_vd = medidas.cd_ctr_un
     LEFT JOIN pdv_vd_orc pvo ON pvo.cd_emp = cp.cd_emp AND pvo.cd_filial = cp.cd_filial AND pvo.cd_vd = cp.cd_vd;

ALTER TABLE public.v_nfce
    OWNER TO postgres;



CREATE OR REPLACE VIEW public.v_pdv_vd AS
 SELECT pdv_vd.cd_emp,
    pdv_vd.cd_filial,
    pdv_vd.cd_cx,
    pdv_vd.cd_vd,
    pdv_vd.cd_cli,
    0 AS cd_adm_cartao,
    pdv_vd.vlr_vd,
    pdv_vd.vlr_liq_vd,
    pdv_vd.vlr_tot_prod,
    pdv_vd.vlr_desc,
    pdv_vd.vlr_desc_itens,
    pdv_vd.vlr_dinh,
    pdv_vd.vlr_chqs,
    pdv_vd.vlr_cartao,
    pdv_vd.vlr_tickets,
    pdv_vd.vlr_dup,
    pdv_vd.vlr_conv,
    pdv_vd.nr_ecf,
    pdv_vd.cd_nf,
    pdv_vd.dt_vd,
    pdv_vd.hr_vd,
    pdv_vd.st_vd,
    pdv_vd.cd_usu,
    pdv_vd.nr_orc,
    pdv_vd.vs_pdv,
    pdv_vd.vs_pdv_rc,
    pdv_vd.nsu_conv_ext,
    pdv_vd.vl_chqs_a_vista,
    pdv_vd.vl_chqs_a_prz,
    pdv_vd.orig_orc,
    pdv_vd.vlr_troco_chq,
    ''::character varying(10) AS nr_autorizacao,
    pdv_vd.nr_cartao_marka,
    pdv_vd.tipo,
    0 AS cod_bandeira,
    0 AS cod_rede,
    0 AS cod_modalidade,
    pdv_vd.alt_recbto,
    pdv_vd.cd_usu_cancel,
    0 AS vlr_saque_cartao,
    pdv_vd.st_canc_paf,
    COALESCE(pdv_vd.vd_troca_fidel, 0::numeric) AS vd_troca_fidel,
    COALESCE(pdv_vd.nr_ped_televd, 0::numeric) AS nr_ped_televd,
    COALESCE(pdv_vd.cd_conv, 0::numeric) AS cd_conv,
    pdv_vd.cgc_cpf,
    pdv_vd.end_cli,
    pdv_vd.resp_imp_dados_consumidor,
    COALESCE(pdv_vd.sts_orc_pend_televd, 0::numeric) AS sts_orc_pend_televd,
    COALESCE(pdv_vd.flag_consolidado, 0) AS flag_consolidado,
    pdv_vd.nm_comprador,
    COALESCE(pdv_vd.qt_parc_conv, 0) AS qt_parc_conv,
    COALESCE(pdv_vd.vlr_ncc, 0::numeric) AS vlr_ncc,
    COALESCE(pdv_vd.perc_rec_conv, 0::numeric) AS perc_rec_conv,
    COALESCE(pdv_vd.tp_perc_rec_conv, 0) AS tp_perc_rec_conv,
    COALESCE(pdv_vd.dados_adicionais, ''::text) AS dados_adicionais,
    COALESCE(pdv_vd.cd_mov, 0::double precision) AS cd_mov,
    COALESCE(pdv_vd.vlr_recarga_cel, 0::numeric) AS vlr_recarga_cel,
    COALESCE(pdv_vd.nr_cel_recarga, ''::character varying) AS nr_cel_recarga,
    0 AS nr_oper_cel,
    COALESCE(pdv_vd.cd_cli_pbm, 0::numeric) AS cd_cli_pbm,
    pdv_vd.qtd_dias_prorrog,
    pdv_vd.nm_oper_cel,
    pdv_vd.vlr_conv_pbm,
    pdv_vd.envio_marka,
    pdv_vd.nr_autorizacao_marka,
    pdv_vd.tipo_pbm
   FROM pdv_vd
  WHERE pdv_vd.st_vd > '-1'::integer::numeric;

ALTER TABLE public.v_pdv_vd
    OWNER TO postgres;



CREATE OR REPLACE VIEW public.v_cupomfiscal AS
 SELECT vd.cd_emp,
    vd.cd_filial,
    vd.cd_cx,
    vd.dt_vd,
    COALESCE(vd.dt_cad, vd.dt_vd) AS dt_cad,
    COALESCE(vd.hr_vd, vd.dt_cad) AS hr_vd,
    vd.nr_orc,
    vd.nr_ped_televd,
    vd.orig_orc AS origem_orc,
    vd.cd_vd,
    vd.nr_ecf,
    vd.st_vd,
    vd.cont_cupom_fisc AS contador_cupom_fiscal,
    vd.cd_mov AS codigo_movimento,
    NULL::character varying AS cgc_filial,
    NULL::character varying AS nm_filial,
    vd.cd_cli,
    vd.cgc_cpf AS cgc_cli,
    NULL::character varying AS nm_cli,
    vd.nr_cartao_marka AS numero_cartao,
    vd.cd_conv,
    NULL::integer AS cd_cli_conv,
    NULL::character varying AS cgc_conv,
    NULL::character varying AS nm_conv,
    COALESCE(vd.qtd_dias_prorrog, 0) AS dias_prorrog_conv,
    COALESCE(vd.tp_vd_api, 0) AS tp_vd_api,
    COALESCE(vd.nr_cartao_api, ''::character varying) AS nr_cartao_api,
    vd.vlr_liq_vd,
    vd.vlr_tot_prod,
    vd.vlr_vd,
    vd.vlr_desc,
    vd.vlr_desc_itens,
    vd.vlr_dinh,
    vd.vlr_troco,
        CASE
            WHEN vd.tipo_pbm > 0 AND COALESCE(vd.vlr_conv_pbm, 0::numeric) = 0::numeric AND vd.vlr_conv = 0::numeric THEN 0::numeric
            ELSE vd.vlr_conv
        END AS vlr_conv,
    vd.qt_parc_conv,
    vd.vlr_dup,
    vd.vl_chqs_a_vista AS valor_cheque_a_vista,
    vd.vl_chqs_a_prz AS valor_cheque_a_prazo,
    ncc.cd_ctr_ncc,
    ncc.vlr_ncc,
    vd.nr_cel_recarga,
    vd.vlr_recarga_cel,
    vd.nm_oper_cel,
    vd.nm_comprador,
    vd.dados_adicionais,
    vd.nr_serie_imp AS nr_serie_ecf,
    vd.vs_pdv AS versao_pdv,
    vd.vs_pdv_rc AS versao_pdv_rc,
    NULLIF(COALESCE(vd.vlr_dinh, 0::numeric) <> 0::numeric, false) AS contem_dinheiro,
        CASE
            WHEN vd.tipo_pbm > 0 AND COALESCE(vd.vlr_conv_pbm, 0::numeric) = 0::numeric AND vd.vlr_conv = 0::numeric THEN NULL::boolean
            ELSE true
        END AS contem_convenio,
    NULLIF(COALESCE(vd.vlr_dup, 0::numeric) <> 0::numeric, false) AS contem_duplicata,
    NULLIF(COALESCE(ncc.vlr_ncc, 0::numeric) <> 0::numeric, false) AS contem_ncc,
    NULLIF(COALESCE(vd.vlr_recarga_cel, 0::numeric) <> 0::numeric, false) AS contem_recarga_cel,
    vd.cd_usu AS cd_operador,
    ''::character varying AS nm_operador,
    vd.cd_usu_cancel,
    ''::character varying AS nm_usu_cancel,
    vd.cd_mt_cancel AS codigo_motivo_cancelamento,
    NULLIF(vd.st_vd <> 0::numeric, false) AS is_cancelado,
    vd.st_canc_paf = 1 AS is_cancelado_paf,
    COALESCE(vd.st_canc_paf, 0) AS st_canc_paf,
    COALESCE(audit.cd_outr_procd, 0::numeric) AS cd_outro_procedimento,
    COALESCE(audit.cd_usu, 0::numeric) AS cd_usu_procedimento,
    COALESCE(vd.cd_cli_pbm, 0::numeric(10,0)) AS cd_cli_pbm,
    COALESCE(vd.reg_alterado, 0) = 1 AS registroalterado,
    vd.vd_troca_fidel AS is_debitar_pontos,
    COALESCE(vd.vlr_imposto, 0::numeric) AS valor_ibpt,
    COALESCE(vd.tx_med_imposto, 0::numeric) AS percentual_ibpt,
    COALESCE(vd.flag_consolidado, 0) AS flag_consolidado,
    vd.vlr_conv_pbm,
    vd.flag_nfce,
    nf_sai.cd_nf AS cd_nf_sai,
    nfce_cancel.cd_vd AS cancel_nfce,
    COALESCE(nfce_cancel.xml_canc, ''::character varying) AS xml_cancel,
    COALESCE(nfce_cancel.tp_canc, 0) AS tp_canc,
    COALESCE(nfce_cancel.chv_nfce, ''::character varying) AS chv_nfce_cancel,
    nfce_cancel.dt_emis AS dt_emis_cancel,
    COALESCE(nfce_cancel.aut_canc, ''::character varying) AS aut_canc,
    COALESCE(nfce_cancel.ds_motivo, ''::character varying) AS ds_motivo_cancel,
    COALESCE(vd.nr_cartao_marka, ''::character varying) AS nr_cartao_marka,
    COALESCE(vd.qtde_pontos_fidel_externo, 0::numeric) AS qtde_pontos_fidel_externo,
    COALESCE(vd.nr_tel_cupom, ''::character varying) AS nr_tel_cupom,
    COALESCE(vd.nr_mfe, 0) AS nr_mfe
   FROM pdv_vd vd
     LEFT JOIN pdv_vd_est_nf_sai nf_sai ON vd.cd_emp = nf_sai.cd_emp AND vd.cd_filial = nf_sai.cd_filial AND vd.cd_vd = nf_sai.cd_vd
     LEFT JOIN est_nfce_env e_nfce ON vd.cd_emp = e_nfce.cd_emp AND vd.cd_filial = e_nfce.cd_filial AND vd.nr_ecf = e_nfce.cd_nf::numeric AND vd.cd_nf_serie::text = e_nfce.cd_nf_serie::text
     LEFT JOIN pdv_vd_ncc ncc ON vd.cd_emp = ncc.cd_emp AND vd.cd_filial = ncc.cd_filial AND vd.cd_vd = ncc.cd_vd
     LEFT JOIN pdv_vd_glb_procd_outr_lib audit ON vd.cd_emp = audit.cd_emp AND vd.cd_filial = audit.cd_filial AND vd.cd_vd = audit.cd_vd AND (audit.cd_outr_procd = ANY (ARRAY[90::numeric, 91::numeric, 93::numeric, 94::numeric]))
     LEFT JOIN est_nfce_canc nfce_cancel ON vd.cd_emp = nfce_cancel.cd_emp AND vd.cd_filial = nfce_cancel.cd_filial AND vd.cd_vd = nfce_cancel.cd_vd
  WHERE vd.st_vd > '-1'::integer::numeric;

ALTER TABLE public.v_cupomfiscal
    OWNER TO postgres;

